/** 
  * Template Name: Home Property
  * Version: 1.2
  * Template Scripts
 * Author : TemplateStocks
  * Author URI: https://www.TemplateStocks.com/

  Custom JS


  1. FIXED NAVBAR
  2. AGENTS SLIDER
  3. TESTIMONIAL SLIDER
  4. CLIENT BRAND SLIDER ( SLICK SLIDER )
  5. TOP SLIDER ( SLICK SLIDER )
  6. LATEST PRODUCT SLIDER ( SLICK SLIDER )
  7. HOVER DROPDOWN MENU
  8. ADVANCE SEARCH FILTER  ( noUiSlider SLIDER )
  9. LIGHTBOX ( FOR PORTFOLIO POPUP VIEW )
  10. SCROLL TOP BUTTON
  11. PRELOADER
  12. GRID AND LIST LAYOUT CHANGER
  13.RELATED ITEM SLIDER ( SLICK SLIDER )


**/


(function($) {


  /* ----------------------------------------------------------- */
  /*  1. FIXED NAVBAR
  /* ----------------------------------------------------------- */


  jQuery(window).bind('scroll', function () {

    if (jQuery(window).scrollTop() > 200) {

        jQuery('.main-navbar').addClass('navbar-fixed-top');

      } else {
          jQuery('.main-navbar').removeClass('navbar-fixed-top');
      }
  });

  /* ----------------------------------------------------------- */
  /*  2. AGENTS SLIDER
  /* ----------------------------------------------------------- */

    jQuery('.aa-agents-slider').slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 300,
      slidesToShow: 4,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 2500,
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 3,
            slidesToScroll: 3,
            infinite: true,
            dots: true
          }
        },
        {
          breakpoint: 600,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 2
          }
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1
          }
        }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ]
    });

  /* ----------------------------------------------------------- */
  /*  3. TESTIMONIAL SLIDER
  /* ----------------------------------------------------------- */

    jQuery('.aa-testimonial-slider').slick({
        dots: false,
        infinite: true,
        speed: 500,
        cssEase: 'linear'
      });

  /* ----------------------------------------------------------- */
  /*  4. CLIENT BRAND SLIDER (SLICK SLIDER)
  /* ----------------------------------------------------------- */

   jQuery('.aa-client-brand-slider').slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 300,
      slidesToShow: 5,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 2500,
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 4,
            slidesToScroll: 4,
            infinite: true,
            dots: true
          }
        },
        {
          breakpoint: 600,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 2
          }
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1
          }
        }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ]
    });


  /* ----------------------------------------------------------- */
  /*  5. TOP SLIDER (SLICK SLIDER)
  /* ----------------------------------------------------------- */

    jQuery('.aa-top-slider').slick({
      dots: false,
      infinite: true,
      arrows: true,
      speed: 500,
      fade: true,
      cssEase: 'linear'
    });

  /* ----------------------------------------------------------- */
  /*  6. LATEST PRODUCT SLIDER (SLICK SLIDER)
  /* ----------------------------------------------------------- */

    jQuery('.aa-properties-details-img').slick({
      dots: false,
      infinite: true,
      arrows: true,
      speed: 500,
      cssEase: 'linear'
    });


  /* ----------------------------------------------------------- */
  /*  7. HOVER DROPDOWN MENU
  /* ----------------------------------------------------------- */

  // for hover dropdown menu
    jQuery('ul.nav li.dropdown').hover(function() {

      jQuery(this).find('.dropdown-menu').stop(true, true).delay(200).fadeIn(200);

    }, function() {

      jQuery(this).find('.dropdown-menu').stop(true, true).delay(200).fadeOut(200);

    });


  /* ----------------------------------------------------------- */
  /* 8. ADVANCE SEARCH FILTER  (noUiSlider SLIDER)
  /* ----------------------------------------------------------- */

    jQuery(function(){

      if(jQuery('body').is('.aa-price-range')){

        // FOR AREA SECTION

       var skipSlider = document.getElementById('aa-sqrfeet-range');

        noUiSlider.create(skipSlider, {
            range: {
              'min': 0,
              '10%': 100,
              '20%': 200,
              '30%': 300,
              '40%': 400,
              '50%': 500,
              '60%': 600,
              '70%': 700,
              '80%': 800,
              '90%': 900,
              'max': 1000
            },
            snap: true,
            connect: true,
            start: [200, 700]
        });

        // for value print

        var skipValues = [
          document.getElementById('skip-value-lower'),
          document.getElementById('skip-value-upper')
        ];

        skipSlider.noUiSlider.on('update', function( values, handle ) {

          skipValues[handle].innerHTML = values[handle];

        });

        // FOR PRICE SECTION

        var skipSlider2 = document.getElementById('aa-price-range');
        noUiSlider.create(skipSlider2, {
            range: {
                'min': 0,
                '10%': 100,
                '20%': 200,
                '30%': 300,
                '40%': 400,
                '50%': 500,
                '60%': 600,
                '70%': 700,
                '80%': 800,
                '90%': 900,
                'max': 1000
            },
            snap: true,
            connect: true,
            start: [200, 700]
        });

        // for value print

        var skipValues2 = [
          document.getElementById('skip-value-lower2'),
          document.getElementById('skip-value-upper2')
        ];

        skipSlider2.noUiSlider.on('update', function( values, handle ) {

          skipValues2[handle].innerHTML = values[handle];

        });
      }
    });


	/* ----------------------------------------------------------- */
	/*  9. LIGHTBOX ( FOR PORTFOLIO POPUP VIEW )
	/* ----------------------------------------------------------- */

	$('body').append("<div id='portfolio-popup'><div class='portfolio-popup-area'><div class='portfolio-popup-inner'></div></div></div>");

	// WHEN CLICK PLAY BUTTON

    jQuery('.aa-single-gallery-info').on('click', function(event) {

      event.preventDefault();

      $('#portfolio-popup').addClass("portfolio-popup-show");

      $('#portfolio-popup').animate({
	      "opacity": 1
      },500);

      var portfolio_detailscontent = $(this).parent(".aa-single-gallery-item").find(".portfolio-detail").html();

	  $(".portfolio-popup-inner").html(portfolio_detailscontent);

    });

    // WHEN CLICK CLOSE BUTTON

    $(document).on('click','.modal-close-btn', function(event) {

	    event.preventDefault();

		$('#portfolio-popup').removeClass("portfolio-popup-show");

		$('#portfolio-popup').animate({
		      "opacity": 0
	    },500);

    });

  /* ----------------------------------------------------------- */
  /*  10. SCROLL TOP BUTTON
  /* ----------------------------------------------------------- */

  //Check to see if the window is top if not then display button

    jQuery(window).scroll(function(){

      if (jQuery(this).scrollTop() > 300) {

        jQuery('.scrollToTop').fadeIn();

      } else {

        jQuery('.scrollToTop').fadeOut();

      }
    });

    //Click event to scroll to top

    jQuery('.scrollToTop').click(function(){

      jQuery('html, body').animate({scrollTop : 0},800);

      return false;

    });

  /* ----------------------------------------------------------- */
  /*  11. PRELOADER
  /* ----------------------------------------------------------- */

   jQuery(window).load(function() { // makes sure the whole site is loaded

      jQuery('#aa-preloader-area').delay(300).fadeOut('slow'); // will fade out

    })



  /* ----------------------------------------------------------- */
  /*  12. GRID AND LIST LAYOUT CHANGER
  /* ----------------------------------------------------------- */

  jQuery("#aa-list-properties").click(function(e) {

    e.preventDefault(e);

    jQuery(".aa-properties-nav").addClass("aa-list-view");

  });

  jQuery("#aa-grid-properties").click(function(e){

    e.preventDefault(e);

    jQuery(".aa-properties-nav").removeClass("aa-list-view");

  });


  /* ----------------------------------------------------------- */
  /*  13. RELATED ITEM SLIDER (SLICK SLIDER)
  /* ----------------------------------------------------------- */

    jQuery('.aa-related-item-slider').slick({
      dots: false,
      infinite: false,
      speed: 300,
      slidesToShow: 4,
      slidesToScroll: 4,
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 3,
            slidesToScroll: 3,
            infinite: true,
            dots: true
          }
        },
        {
          breakpoint: 600,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 2
          }
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1
          }
        }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ]
    });


})( jQuery );
