/** 
  * Template Name: NextVolt
  * Version: 1 
  * Template Scripts
  * Author : TemplateStocks
  * Author URI: https://templatestocks.com/

  Custom JS
  

  1. ANIMATED COUNTER
  2. LIGHTBOX ( FOR PORTFOLIO POPUP VIEW ) 
  3. FAQ
  4. TEAM SLIDER
  5. MOBILE MENU
  6. MENU SMOOTH SCROLLING
  7. SCROLL TOP BUTTON
  8. SLICK SLIDER ( CLIENT TESTIMONIAL )
  9. CLIENTS LOGO ( SLICK SLIDER)
  10. HERO VIDEO (MODAL VIDEO)

  
**/


(function($) {
  
  /* ----------------------------------------------------------- */
  /*  1. ANIMATED COUNTER
  /* ----------------------------------------------------------- */

  let count = document.querySelectorAll(".ts-count")
  let arr = Array.from(count)
  
  arr.map(function(item){
    let startnumber = 0

    function counterup(){
    startnumber++
    item.innerHTML= startnumber

    if(startnumber == item.dataset.number){
        clearInterval(stop)
      }
    }

    let stop =setInterval(function(){
      counterup()
    },50)

  })

    /* ----------------------------------------------------------- */
	/*  2. LIGHTBOX ( FOR PORTFOLIO POPUP VIEW ) 
	/* ----------------------------------------------------------- */ 
	
	$('body').append("<div id='ts-portfolio-popup'><div class='ts-portfolio-popup-area'><div class='ts-portfolio-popup-inner'></div></div></div>");
	
	// WHEN CLICK PLAY BUTTON 
	
    jQuery('.ts-single-gallery-info').on('click', function(event) {
	    
      event.preventDefault();
      
      $('#ts-portfolio-popup').addClass("ts-portfolio-popup-show");
      
      $('#ts-portfolio-popup').animate({
	      "opacity": 1
      },500);   
      
      var portfolio_detailscontent = $(this).parent(".ts-single-gallery-item").find(".ts-portfolio-detail").html();
      
	  $(".ts-portfolio-popup-inner").html(portfolio_detailscontent);     

    });  
           
    // WHEN CLICK CLOSE BUTTON
    
    $(document).on('click','.modal-close-btn', function(event) {     
	    
	    event.preventDefault();
	    
		$('#ts-portfolio-popup').removeClass("ts-portfolio-popup-show");
		
		$('#ts-portfolio-popup').animate({
		      "opacity": 0
	    },500);  

    });
  
  
  /* ----------------------------------------------------------- */
  /*  3. FAQ
  /* ----------------------------------------------------------- */

  var coll = document.getElementsByClassName("ts-service-collapsible");
  var i;
  
  for (i = 0; i < coll.length; i++) {
    coll[i].addEventListener("click", function() {
      this.classList.toggle("active");
      var content = this.nextElementSibling;
      if (content.style.maxHeight){
        content.style.maxHeight = null;
      } else {
        content.style.maxHeight = content.scrollHeight + "px";
      } 
    });
  }

   /* ----------------------------------------------------------- */
  /*  4. TEAM SLIDER ( Slick Slider )
  /* ----------------------------------------------------------- */   

  $('.ts-team-nav').slick({
    dots: false,
    autoplay: true,
    infinite: true,
    speed: 300,
    slidesToShow: 3,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1,
          infinite: true,
          dots: false
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ]
  });



  /* ----------------------------------------------------------- */
  /*  5. MOBILE MENU
  /* ----------------------------------------------------------- */    

 
  $('.toggler').on('click', function() {
		$('nav').slideToggle(500);
    $('.ts-nav li a').on('click', function() {
      document.getElementById("tsMainNav").style.display = "none";
    });
  });


  /* ----------------------------------------------------------- */
  /*  6. MENU SMOOTH SCROLLING
  /* ----------------------------------------------------------- */ 

  let sections = document.querySelectorAll('section');
let navLinks = document.querySelectorAll('header nav ul li a'); 
window.onscroll = () => {
    sections.forEach(sec => {
        let top = window.scrollY;
        let offset = sec.offsetTop - 150; 
        let height = sec.offsetHeight;
        let id = sec.getAttribute('id');
        if(top >= offset && top < offset + height) {
            navLinks.forEach(links => {
                links.classList.remove('ts-active');
                document.querySelector('nav a[href*=' + id + ']').classList.add('ts-active');
            });
        };
    });
};

  $(document).ready(function() {
    $('a[href^="#"]').click(function() {
        var hash = $(this).attr('href');
          $('html, body').animate({
            scrollTop: $(hash).offset().top
          }, 500);
          return false;
      });
  });
  
 
    
  /* ----------------------------------------------------------- */
  /*  7. SCROLL TOP BUTTON
  /* ----------------------------------------------------------- */

  //Check to see if the window is top if not then display button

    jQuery(window).scroll(function(){
	    
      if (jQuery(this).scrollTop() > 300) {
	      
        jQuery('.scrollToTop').fadeIn();
        
      } else {
	      
        jQuery('.scrollToTop').fadeOut();
        
      }
      
    });
     
    // Click event to scroll to top

    jQuery('.scrollToTop').click(function(){
	    
      jQuery('html, body').animate({scrollTop : 0},800);
      
      return false;
      
    });


    
  /* ----------------------------------------------------------- */
  /*  8. SLICK SLIDER ( CLIENT TESTIMONIAL )
  /* ----------------------------------------------------------- */   
    
  $('.ts-testimonial-slider').slick({
    dots: true,
    arrows: false,
    autoplay: true,
    infinite: true,
    speed: 300,
    slidesToShow: 2,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true,
          dots: true
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ]
  });


   /* ----------------------------------------------------------- */
  /*  9. CLIENTS LOGO ( SLICK SLIDER)
  /* ----------------------------------------------------------- */   
    
  $('.ts-client-logo').slick({
    dots: false,
    arrows: false,
    autoplay: true,
    infinite: true,
    speed: 300,
    slidesToShow: 5,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 4,
          slidesToScroll: 1,
          infinite: true,
          dots: false
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      }
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ]
  });


 /* ----------------------------------------------------------- */
  /*  10. HERO VIDEO (MODAL VIDEO)
  /* ----------------------------------------------------------- */ 

  // Get the modal
  var modal = document.getElementById("VideoModal");

  // Get the button that opens the modal
  var btn = document.getElementById("videobtn");

  // Get the <span> element that closes the modal
  var span = document.getElementsByClassName("ts-close")[0];

  // When the user clicks on the button, open the modal
  btn.onclick = function() {
    modal.style.display = "block";
  }

  // When the user clicks on <span> (x), close the modal
  span.onclick = function() {
    modal.style.display = "none";
  }

  // When the user clicks anywhere outside of the modal, close it
  window.onclick = function(event) {
    if (event.target == modal) {
      modal.style.display = "none";
    }
  }

   
})( jQuery );

