/** 
  * Template Name: NexusFit
  * Version: 1 
  * Template Scripts
  * Author : TemplateStocks
  * Author URI: https://templatestocks.com/

  Custom JS
  

  1. FIXED NAVBAR 
  2. MOBILE MENUE
  3. TOP SLIDER (SLICK SLIDER)
  4. SLICK SLIDER ( CLIENT TESTIMONIAL )
  5. TRAINING SESSION 
  6. SLICK SLIDER ( CLIENT LOGO )
  7. ANIMATED COUNTER
  8. SCROLL TOP BUTTON
  9. MENU SMOOTH SCROLLING
 10. FANCYBOX JS
  

  
**/


(function($) {

  /* ----------------------------------------------------------- */
  /*  1. FIXED NAVBAR 
  /* ----------------------------------------------------------- */
    
    
  jQuery(window).bind('scroll', function () {
	  
    if (jQuery(window).scrollTop() > 200) {
	    
        jQuery('#ts-header').addClass('ts-navbar-bg'); 
      
      } else {
          jQuery('#ts-header').removeClass('ts-navbar-bg');          
      }
  });

  /* ----------------------------------------------------------- */
  /*  2. MOBILE MENUE
  /* ----------------------------------------------------------- */  

  $("label[for=showDrop]").on('click', function() {
    $('label[for=showDrop] .fa-chevron-up, label[for=showDrop] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });

   $("label[for=showDrop2]").on('click', function() {
    $('label[for=showDrop2] .fa-chevron-up, label[for=showDrop2] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });

   $("label[for=showDrop3]").on('click', function() {
    $('label[for=showDrop3] .fa-chevron-up, label[for=showDrop3] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });

   $("label[for=showDrop4]").on('click', function() {
    $('label[for=showDrop4] .fa-chevron-up, label[for=showDrop4] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });

   

   /* ----------------------------------------------------------- */
  /*  3. TOP SLIDER (SLICK SLIDER)
  /* ----------------------------------------------------------- */    

  jQuery('.ts-top-slider').slick({
    dots: false,
    infinite: true,
    arrows: true,
    speed: 500,     
    autoplay: true,
    fade: true,
    cssEase: 'linear'
  });

  /* ----------------------------------------------------------- */
  /*  4. SLICK SLIDER ( CLIENT TESTIMONIAL )
  /* ----------------------------------------------------------- */   

  $('.ts-testimonial-slider').slick({
    dots: false,
    autoplay: true,
    infinite: true,
    speed: 300,
    slidesToShow: 3,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1,
          infinite: true,
          dots: false
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ]
  });


  /* ----------------------------------------------------------- */
  /*  5. TRAINING SESSION 
  /* ----------------------------------------------------------- */   

  $('.ts-training-session-slide').slick({
    dots: false,
    autoplay: true,
    infinite: true,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1,
          infinite: true,
          dots: false
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ]
  });

  /* ----------------------------------------------------------- */
  /*  6. SLICK SLIDER ( CLIENT LOGO )
  /* ----------------------------------------------------------- */   

  $('.ts-client-logo').slick({
    dots: false,
    arrows: false,
    autoplay: true,
    infinite: true,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1,
          infinite: true,
          dots: false
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ]
  });
    
  
  /* ----------------------------------------------------------- */
  /* 7. ANIMATED COUNTER
  /* ----------------------------------------------------------- */

  let count = document.querySelectorAll(".ts-count")
  let arr = Array.from(count)
  
  arr.map(function(item){
    let startnumber = 0

    function counterup(){
    startnumber++
    item.innerHTML= startnumber

    if(startnumber == item.dataset.number){
        clearInterval(stop)
      }
    }

    let stop =setInterval(function(){
      counterup()
    },50)

  })


  /* ----------------------------------------------------------- */
  /*  8. SCROLL TOP BUTTON
  /* ----------------------------------------------------------- */

  //Check to see if the window is top if not then display button

  jQuery(window).scroll(function(){
	    
    if (jQuery(this).scrollTop() > 300) {
      
      jQuery('.scrollToTop').fadeIn();
      
    } else {
      
      jQuery('.scrollToTop').fadeOut();
      
    }
    
  });
   
  // Click event to scroll to top

  jQuery('.scrollToTop').click(function(){
    
    jQuery('html, body').animate({scrollTop : 0},800);
    
    return false;
    
  });

  /* ----------------------------------------------------------- */
  /*  9. MENU SMOOTH SCROLLING
  /* ----------------------------------------------------------- */ 
  
  $(document).ready(function() {
    $('a[href^="#"]').click(function() {
      var hash = $(this).attr('href');
        $('html, body').animate({
          scrollTop: $(hash).offset().top
        }, 900);
        return false;
    });
  });



 /* ----------------------------------------------------------- */
  /*  10. FANCYBOX JS
  /* ----------------------------------------------------------- */

    // 1. querySelector
    var containerEl = document.querySelector(".ts-gallery-item");
    // 2. Passing the configuration object inline
    //https://www.kunkalabs.com/mixitup/docs/configuration-object/
    var mixer = mixitup(containerEl, {
      animation: {
        effects: "fade translateZ(-100px)",
        effectsIn: "fade translateY(-100%)",
        easing: "cubic-bezier(0.645, 0.045, 0.355, 1)"
      }
    });
    // fancybox insilaze & options //
    jQuery("[data-fancybox]").fancybox({
      loop: true,
      hash: true,
      transitionEffect: "slide",
      /* zoom VS next////////////////////
      clickContent - i modify the deafult - now when you click on the image you go to the next image - i more like this approach than zoom on desktop (This idea was in the classic/first lightbox) */
      clickContent: function(current, event) {
        return current.type === "image" ? "next" : false;
      }
    });

  

   
})( jQuery );

