/** 
  * Template Name: PolyX
  * Version: 1 
  * Template Scripts
  * Author : TemplateStocks
  * Author URI: https://templatestocks.com/

  Custom JS
  

  1. PROGRESS BAR  
  2. ANIMATED COUNTER
  3. FANCYBOX JS ( PORTFOLIO )
  4. MOBILE MENU 
  5. MENU SMOOTH SCROLLING
  6. SCROLL TOP BUTTON
  7. TYPE WRITER
  8. SLICK SLIDER ( CLIENT TESTIMONIAL )

  
**/


(function($) {

  /* ----------------------------------------------------------- */
  /*  1. PROGRESS BAR 
  /* ----------------------------------------------------------- */

  $(".progress-bar").ProgressBar();

  
  /* ----------------------------------------------------------- */
  /*  2. ANIMATED COUNTER
  /* ----------------------------------------------------------- */

  let count = document.querySelectorAll(".ts-count")
  let arr = Array.from(count)
  
  arr.map(function(item){
    let startnumber = 0

    function counterup(){
    startnumber++
    item.innerHTML= startnumber

    if(startnumber == item.dataset.number){
        clearInterval(stop)
      }
    }

    let stop =setInterval(function(){
      counterup()
    },50)

  })
  /* ----------------------------------------------------------- */
  /*  3. FANCYBOX JS
  /* ----------------------------------------------------------- */

    // 1. querySelector
    var containerEl = document.querySelector(".ts-portfolio-item");
    // 2. Passing the configuration object inline
    //https://www.kunkalabs.com/mixitup/docs/configuration-object/
    var mixer = mixitup(containerEl, {
      animation: {
        effects: "fade translateZ(-100px)",
        effectsIn: "fade translateY(-100%)",
        easing: "cubic-bezier(0.645, 0.045, 0.355, 1)"
      }
    });
    // fancybox insilaze & options //
    jQuery("[data-fancybox]").fancybox({
      loop: true,
      hash: true,
      transitionEffect: "slide",
      /* zoom VS next////////////////////
      clickContent - i modify the deafult - now when you click on the image you go to the next image - i more like this approach than zoom on desktop (This idea was in the classic/first lightbox) */
      clickContent: function(current, event) {
        return current.type === "image" ? "next" : false;
      }
    });

  /* ----------------------------------------------------------- */
  /*  4. MOBILE MENU
  /* ----------------------------------------------------------- */    

 
  $('.toggler').on('click', function() {
		$('nav').slideToggle(500);
    $('.ts-nav li a').on('click', function() {
      document.getElementById("tsMainNav").style.display = "none";
    });
  });


  /* ----------------------------------------------------------- */
  /*  5. MENU SMOOTH SCROLLING
  /* ----------------------------------------------------------- */ 

  $(document).ready(function() {
    $('a[href^="#"]').click(function() {
        var hash = $(this).attr('href');
          $('html, body').animate({
            scrollTop: $(hash).offset().top
          }, 500);
          return false;
      });
  });
  
 
    
  /* ----------------------------------------------------------- */
  /*  6. SCROLL TOP BUTTON
  /* ----------------------------------------------------------- */

  //Check to see if the window is top if not then display button

    jQuery(window).scroll(function(){
	    
      if (jQuery(this).scrollTop() > 300) {
	      
        jQuery('.scrollToTop').fadeIn();
        
      } else {
	      
        jQuery('.scrollToTop').fadeOut();
        
      }
      
    });
     
    // Click event to scroll to top

    jQuery('.scrollToTop').click(function(){
	    
      jQuery('html, body').animate({scrollTop : 0},800);
      
      return false;
      
    });

  /* ----------------------------------------------------------- */
  /*  7. TYPE WRITER
  /* ----------------------------------------------------------- */  

    $(document).ready(function() {
      $("#ts-typewriter").typewriter({
          prefix : "I'am",
          text : ["John Doe", "Web Developer", "Designer"],
          typeDelay : 100,
          waitingTime : 1500,
          blinkSpeed : 800
      });
    });

    
  /* ----------------------------------------------------------- */
  /*  8. SLICK SLIDER ( CLIENT TESTIMONIAL )
  /* ----------------------------------------------------------- */   
    $('.ts-testimonial-slider').slick({
      dots: true,      
      infinite: true,
      arrows: true,
      autoplay: true,
      speed: 500,      
      cssEase: 'linear'
    }); 
   
 

   
})( jQuery );

