/** 
  * Template Name: Toothify
  * Version: 1.1.2
  * Template Scripts
  * Author : TemplateStocks
  * Author URI: https://templatestocks.com/

  Custom JS
  

  1. MOBILE MENUE
  2. SLICK SLIDER ( CLIENT TESTIMONIAL )
  3. SERVICE FAQ
  4. SCROLL TOP BUTTON
  5. MENU SMOOTH SCROLLING
  6. LIGHTBOX ( FOR PORTFOLIO POPUP VIEW ) 
  7. WORK PROCESS (MODAL VIDEO)
  
  
**/


(function($) {

  /* ----------------------------------------------------------- */
  /*  1. MOBILE MENUE
  /* ----------------------------------------------------------- */  

  $("label[for=showDrop]").on('click', function() {
    $('label[for=showDrop] .fa-chevron-up, label[for=showDrop] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });

   $("label[for=showDrop2]").on('click', function() {
    $('label[for=showDrop2] .fa-chevron-up, label[for=showDrop2] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });

   $("label[for=showDrop3]").on('click', function() {
    $('label[for=showDrop3] .fa-chevron-up, label[for=showDrop3] .fa-chevron-down').toggleClass("fa-chevron-up fa-chevron-down");
    
   });
  
  
  /* ----------------------------------------------------------- */
  /*  2. SLICK SLIDER ( CLIENT TESTIMONIAL )
  /* ----------------------------------------------------------- */   

    $('.ts-testimonial-slider').slick({
      slidesToShow: 1,
      slidesToScroll: 1,
      autoplay: true,
      dots: false,
      autoplaySpeed: 2000,
    });
   

  /* ----------------------------------------------------------- */
  /*  3. SERVICE FAQ
  /* ----------------------------------------------------------- */
  
  var coll = document.getElementsByClassName("ts-faq-collapsible");
  var i;
  
  for (i = 0; i < coll.length; i++) {
    coll[i].addEventListener("click", function() {
      this.classList.toggle("active");
      var content = this.nextElementSibling;
      if (content.style.maxHeight){
        content.style.maxHeight = null;
      } else {
        content.style.maxHeight = content.scrollHeight + "px";
      } 
    });
  }


  /* ----------------------------------------------------------- */
  /*  4. SCROLL TOP BUTTON
  /* ----------------------------------------------------------- */

  //Check to see if the window is top if not then display button

  jQuery(window).scroll(function(){
	    
    if (jQuery(this).scrollTop() > 300) {
      
      jQuery('.scrollToTop').fadeIn();
      
    } else {
      
      jQuery('.scrollToTop').fadeOut();
      
    }
    
  });
   
  // Click event to scroll to top

  jQuery('.scrollToTop').click(function(){
    
    jQuery('html, body').animate({scrollTop : 0},800);
    
    return false;
    
  });


  /* ----------------------------------------------------------- */
  /*  5. MENU SMOOTH SCROLLING
  /* ----------------------------------------------------------- */ 

  $(document).ready(function() {
    $('a[href^="#"]').click(function() {
      var hash = $(this).attr('href');
        $('html, body').animate({
          scrollTop: $(hash).offset().top
        }, 900);
        return false;
    });
  });


  /* ----------------------------------------------------------- */
	/*  6. LIGHTBOX ( FOR PORTFOLIO POPUP VIEW ) 
	/* ----------------------------------------------------------- */ 
	
	$('body').append("<div id='ts-portfolio-popup'><div class='ts-portfolio-popup-area'><div class='ts-portfolio-popup-inner'></div></div></div>");
	
	// WHEN CLICK PLAY BUTTON 
	
    jQuery('.ts-single-gallery-info').on('click', function(event) {
	    
      event.preventDefault();
      
      $('#ts-portfolio-popup').addClass("ts-portfolio-popup-show");
      
      $('#ts-portfolio-popup').animate({
	      "opacity": 1
      },500);   
      
      var portfolio_detailscontent = $(this).parent(".ts-single-gallery-item").find(".ts-portfolio-detail").html();
      
	  $(".ts-portfolio-popup-inner").html(portfolio_detailscontent);     

    });  
           
    // WHEN CLICK CLOSE BUTTON
    
    $(document).on('click','.modal-close-btn', function(event) {     
	    
	    event.preventDefault();
	    
		$('#ts-portfolio-popup').removeClass("ts-portfolio-popup-show");
		
		$('#ts-portfolio-popup').animate({
		      "opacity": 0
	    },500);  

    });


  /* ----------------------------------------------------------- */
  /*  7. WORK PROCESS (MODAL VIDEO)
  /* ----------------------------------------------------------- */ 

  // Get the modal
  var modal = document.getElementById("VideoModal");

  // Get the button that opens the modal
  var btn = document.getElementById("videobtn");

  // Get the <span> element that closes the modal
  var span = document.getElementsByClassName("ts-close")[0];

  // When the user clicks on the button, open the modal
  btn.onclick = function() {
    modal.style.display = "block";
  }

  // When the user clicks on <span> (x), close the modal
  span.onclick = function() {
    modal.style.display = "none";
  }

  // When the user clicks anywhere outside of the modal, close it
  window.onclick = function(event) {
    if (event.target == modal) {
      modal.style.display = "none";
    }
  }


   
})( jQuery );

